// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : mainOptions.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////



#include "Options.h"
#include "input.h"
#include "Util.h"
#include "Button.h"
#include "Application.h"
#include "MainMenu.h"



Options::Options()
{

  m_CurBarPos       = 320.0f;
  m_BarTargetTime   = 0.0f;

  m_BarPos          = 0;
  m_BarStartPos     = 0;

  m_BarXPos[0]      = 50;
  m_BarXPos[1]      = 30;
  m_BarXPos[2]      = 30;

  m_BarColor[0]     = 0xffffffff;
  m_BarColor[1]     = 0xffc0c0c0;
  m_BarColor[2]     = 0xffc0c0c0;

}

Options::~Options() 
{
}



void Options::Init()
{

}



void Options::Exit()
{

}



void Options::Update() 
{

  if ( g_App.m_Input.KeyPressed( VK_ESCAPE ) ) 
  { 
    g_App.ChangeGameState( new Menu() );
  }
  if ( g_App.m_Input.KeyPressed( VK_LEFT ) ) 
  {
    if ( m_BarPos == 0 )
    {
      if ( Sound::Volume() > 0 )
      {
        Sound::SetVolume( Sound::Volume() - 10 );
        g_App.PlaySound( "Menu.Blip" );
      }
    }
  }
  if ( g_App.m_Input.KeyPressed( VK_RIGHT ) ) 
  {
    if ( m_BarPos == 0 )
    {
      if ( Sound::Volume() < 100 )
      {
        Sound::SetVolume( Sound::Volume() + 10 );
        g_App.PlaySound( "Menu.Blip" );
      }
    }
  }

  if ( g_App.m_Input.KeyPressed( VK_UP ) ) 
  {
    if ( m_BarPos > 0 )
    {
      m_BarStartPos = m_BarPos;
      m_BarPos--;
      m_BarTargetTime = 0.25f;
      g_App.PlaySound( "Menu.Select" );
    }
  }
  if ( g_App.m_Input.KeyPressed( VK_DOWN ) ) 
  {
    if ( m_BarPos < 2 )
    {
      m_BarStartPos = m_BarPos;
      m_BarPos++;
      m_BarTargetTime = 0.25f;
      g_App.PlaySound( "Menu.Select" );
    }
  }
  if ( ( g_App.m_Input.KeyPressed( VK_RETURN ) ) 
  ||   ( g_App.m_Input.KeyPressed( VK_SPACE ) ) )
  {
    switch ( m_BarPos )
    {
      case 1:
        g_App.ToggleWindowMode();
        break;
      case 2:
        g_App.ChangeGameState( new Menu() );
        break;
    }
  }

}



void Options::UpdateTimed( const float ElapsedTime )
{

  if ( m_BarTargetTime > 0.0f )
  {
    m_BarTargetTime -= ElapsedTime;
    if ( m_BarTargetTime < 0.0f )
    {
      m_BarTargetTime = 0.0f;
    }
    m_CurBarPos = 320.0f + 100.0f * m_BarPos - 100.0f * ( m_BarPos - m_BarStartPos ) * sinf( 3.1415926f * 90.0f * ( m_BarTargetTime / 0.25f ) / 180.0f );
  }
  for ( int i = 0; i < 3; ++i )
  {
    if ( i == m_BarPos )
    {
      m_BarXPos[i] = 50 - (int)( 20 * m_BarTargetTime / 0.25f );

      m_BarColor[i] = Util::ModulateColor( 0xffffffff, 0xffc0c0c0, 1.0f - m_BarTargetTime / 0.25f );
    }
    else if ( i == m_BarStartPos )
    {
      m_BarXPos[i] = 30 + (int)( 20 * m_BarTargetTime / 0.25f );
      m_BarColor[i] = Util::ModulateColor( 0xffffffff, 0xffc0c0c0, m_BarTargetTime / 0.25f );
    }
    else
    {
      m_BarXPos[i] = 30;
      m_BarColor[i] = 0xffc0c0c0;
    }
  }

}



void Options::OnMouseWheel( int Dir )
{

}



void Options::Render()
{

  g_App.RenderBackground();

  g_App.RenderTextureSection( "Menu.Bar", 0, (int)m_CurBarPos );

  g_App.RenderTextureSection( "Menu.Volume", m_BarXPos[0], 300, m_BarColor[0] );
  g_App.RenderTextureSection( "Menu.WindowMode", m_BarXPos[1], 400, m_BarColor[1] );
  g_App.RenderTextureSection( "Menu.Back", m_BarXPos[2], 500, m_BarColor[2] );

  for ( int i = 0; i < Sound::Volume() / 10; ++i )
  {
    g_App.RenderTextureSection( "Big.1", 350 + i * 30, 300 );
  }

}